# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import request_valid, online_employee, stamp2datetime, datetime2stamp, interface_response, \
    SUCCESS_CODE, MESSAGE_CODE, SYSTEM_EXCEPTION, DATA_EXCEPTION, paging, save_notification, user_photo, get_sender
from django.utils.translation import ugettext_lazy as _
import json


class BioTimeAppAnnouncement(object):

    """
    【Announcement】公告
    """
    @request_valid
    @ladonize(int, str, str, int, long, int, str, str, str, rtype=str)
    def upload_announcement(self, user, subject, content, category, send_time, source, device_token, language, token):
        """
        新增公告
        @param user:            人员ID, 新增Private时人员ID不能为空
        @param subject:         公告标题（必填）
        @param content:         公告内容（选填）
        @param category:        公告类型，1:Public, 2:Private
        @param send_time:       上传时间（stamp）
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功:
                {"code": 1, "error": "", "describe": "", "message": "", "data":{"message":"弹窗信息"}}
            请求失败:
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        from mysite.iclock.models.model_announcement import Announcement, PUBLIC_ANNOUNCEMENT, PRIVATE_ANNOUNCEMENT
        if category == PRIVATE_ANNOUNCEMENT and not user:
            error = _(u'Data Error')
            describe = _(u'Private announcement must be with user.')
            return interface_response(MESSAGE_CODE, '', error, describe, DATA_EXCEPTION)
        try:
            send_time = stamp2datetime(send_time)
            emp = online_employee()
            anc = Announcement()
            anc.subject = u'{0}'.format(subject.decode('utf-8'))
            anc.content = u'{0}'.format(content.decode('utf-8'))
            anc.category = category
            anc.sender = emp.PIN
            anc.send_time = send_time
            if category == PRIVATE_ANNOUNCEMENT and user:
                anc.emp_id = user
            anc.save()
            data = {
                'message': u'{0}'.format(_(u'Request is processing'))
            }
            return interface_response(SUCCESS_CODE, json.dumps(data), '', '')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

    @request_valid
    @ladonize(int, int, int, str, str, str, rtype=str)
    def pull_announcement(self, category, page_num, source, device_token, language, token):
        """
        获取公告
        @param category:        公告类型， １：Public, ２：Private
        @param page_num:        页码(每页１５条数据)
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功:
                {"code": 1, "error": "", "describe": "", "message": "", "data":[{"code": 对象ID, "subject":"公告标题", "content":"公告内容", "send_time":"公告发送时间(stamp)"},]}
            请求失败:
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.iclock.models.model_announcement import ANNOUNCEMENT_CATEGORY, PRIVATE_ANNOUNCEMENT
        if not category:
            describe = u'{0}'.format(_(u'Params category="{0}" error.'.format(category)))
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
        try:
            emp = online_employee()
            page_num = page_num or 1
            params = {'receiver': emp.pk, 'category': category}
            id_part = {"and": []}
            if category in (PRIVATE_ANNOUNCEMENT, ):
                id_part['and'].append('receiver')
            sql = get_sql('sql', sqlid='announcement', app="pywebsv", params=params, id_part=id_part)
            sql = paging(sql, page_num, 'send_time')
            rows = p_query(sql)
            data = []
            if rows:
                categorys = dict(ANNOUNCEMENT_CATEGORY)
                data = [{'code': r[0], 'name': r[5] or r[7], 'photo': get_sender({'sender': r[4], 'system_sender': r[6]})['photo'],
                         'category': u'{0}'.format(categorys.get(category, category)),
                         'category_val': category,
                         'subject': r[1], 'content': r[2], 'notification_time': datetime2stamp(r[3])} for r in rows]
            return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)


